/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: PropertyMap.java,v 1.3 2004/05/27 11:33:52 jre Exp $
 */

package com.sapportals.wcm.repository;

import java.util.HashMap;
import java.util.Map;

import com.sapportals.wcm.WcmObject;

/**
 * Holds a read-only map of Property objects. <p>
 *
 *
 * Copyright SAP AG 2001-2004
 * @author m.breitenfelder@sap.com
 * @author julian.reschke@greenbytes.de
 * @version $Revision: 1.3 $
 */
public class PropertyMap extends WcmObject implements IPropertyMap {

  protected HashMap map = null;
  protected Map exceptionMap = null;

  /**
   * Constructs a new empty property map
   */
  public PropertyMap() {
    this.map = new HashMap();
  }

  /**
   * Constructs a new property map with the same mappings as the given map
   *
   * @param propMap The map whose mappings are to be places in this map
   */
  public PropertyMap(PropertyMap propMap) {
    this.map = new HashMap(propMap.map);
  }

  protected PropertyMap(int initialCapacity) {
    this.map = new HashMap(initialCapacity);
  }

  protected PropertyMap(Map m) {
    this.map = new HashMap(m);
  }

  public String toString() {
    return this.map.toString();
  }


  // ---------------------------------------------------------------------------
  // IPropertyMap interface
  // ---------------------------------------------------------------------------

  public int size() {
    return this.map.size();
  }

  public boolean isEmpty() {
    return this.map.isEmpty();
  }

  public boolean containsProperty(IPropertyName propertyName) {
    return this.map.containsKey(propertyName);
  }

  public boolean containsProperty(IProperty property) {
    return this.map.containsKey(property.getPropertyName());
  }

  public IProperty get(IPropertyName propertyName) {
    return (IProperty)this.map.get(propertyName);
  }

  public IPropertyIterator iterator() {
    return new PropertyIterator(this.map.values().iterator());
  }

  public IMutablePropertyMap getMutable() {
    return new MutablePropertyMap(this.map);
  }

  public Map getExceptions() {
    return this.exceptionMap == null ? java.util.Collections.EMPTY_MAP : this.exceptionMap;
  }

  public Exception getException(IPropertyName propertyName) {
    return this.exceptionMap == null ? null : (Exception)this.exceptionMap.get(propertyName);
  }
}

