package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.enum.*;
import java.util.*;

public class PropertyCollatorItem {

  private boolean         ascending = true;
  private IPropertyName   propertyname = null;

  public PropertyCollatorItem(boolean ascending, IPropertyName propertyname) {
    this.ascending = ascending;
    this.propertyname = propertyname;
  }

  public boolean isAscending() {
    return this.ascending;
  }

  public IPropertyName getPropertyName() {
    return this.propertyname;
  }

  int compare(IProperty prop1, IProperty prop2) {

    if (null == prop1 && null == prop2)                 return 0;
    if (null == prop2) return (this.ascending == true) ? -1 : 1;
    if (null == prop1) return (this.ascending == true) ? 1 : -1;

    // definitions not equal
    if (false == prop1.getPropertyDef().equals(prop2.getPropertyDef())) {
      return (ascending) ? -1 : 1;
    }

    // multi valued properties not supported
    if (prop1.isMultivalued() == true || prop2.isMultivalued()) {
      return (ascending) ? -1 : 1;
    }

    int compare = 0;

    try {
      PropertyType type = prop1.getPropertyDef().getType();

      if (PropertyType.STRING.equals(type)) {
        String val1 = (String)prop1.getStringValue();
        String val2 = (String)prop2.getStringValue();
        compare = val1.compareTo(val2);
      }
      else if (PropertyType.BOOLEAN.equals(type)) {
        boolean val1 = prop1.getBooleanValue();
        boolean val2 = prop2.getBooleanValue();

        if (val1 == val2)                      compare = 0;
        else if (val1 != val2 && val1 == true) compare = -1;
        else compare = 1;
      }
      else if (PropertyType.DATE.equals(type)) {
        Date val1 = (Date)prop1.getDateValue();
        Date val2 = (Date)prop2.getDateValue();
        compare = val1.compareTo(val2);
      }
      else if (PropertyType.INTEGER.equals(type)) {
        int val1 = prop1.getIntValue();
        int val2 = prop2.getIntValue();

        if (val1 == val2) compare = 0;
        else if (val1 < val2) compare = -1;
        else compare = 1;
      }
      else if (PropertyType.LONG.equals(type)) {
        long val1 = prop1.getIntValue();
        long val2 = prop2.getIntValue();

        if (val1 == val2) compare =0;
        else if (val1 < val2) compare = -1;
        else compare = 1;
      }
      else if (PropertyType.XML.equals(type)) {
        compare = 0;
      }

      if (ascending == false) {
        compare = (compare == -1) ? 1 : -1;
      }

      return compare;
    } catch (Exception ex) {
      //$JL-EXC$ 
      // do nothing: return 0;
      com.sap.tc.logging.Location.getLocation(this.getClass()).debugT(ex.getMessage());     
    }

    return compare;
  }

  public boolean equals(Object o) {
    if (o instanceof PropertyCollatorItem) {
      PropertyCollatorItem ps = (PropertyCollatorItem)o;
      return ((this.ascending == ps.ascending) && (this.propertyname.equals(ps.propertyname)));
    }
    return false;
  }

  public String toString() {
   return this.getPropertyName().toString() + ", collator set to: " + this.ascending;
  }
}

