/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.util.Iterator;

/**
 * An iterator over a collection of property change results.
 */
public class PropertyChangeResultIterator {

  private Iterator it = null;

  public PropertyChangeResultIterator(Iterator it) {
    this.it = it;
  }

  /**
   * Returns <code>true</code> if the iteration has more result elements.
   *
   * @return TBD: Description of the outgoing return value
   */
  public boolean hasNext() {
    return this.it.hasNext();
  }

  /**
   * Returns the next result element in the interation.
   *
   * @return the next result element
   */
  public PropertyChangeResult next() {
    return (PropertyChangeResult)this.it.next();
  }
}
