/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.util.*;

/**
 * A collection of property change results.
 */
public class PropertyChangeResultCollection {

  private List list = null;

  public PropertyChangeResultCollection() {
    this.list = new LinkedList();
  }

  public PropertyChangeResultCollection(PropertyChangeResultCollection collection) {
    this.list = new LinkedList(collection.list);
  }

  /**
   * Returns the number of elements in this collection.
   *
   * @return the number of elements in this collection
   */
  public int size() {
    return this.list.size();
  }

  /**
   * Returns <code>true</code> if the collection contains no elements.
   *
   * @return empty
   */
  public boolean isEmpty() {
    return this.list.isEmpty();
  }

  /**
   * Adds the result to the collection.
   *
   * @param result TBD: Description of the incoming method parameter
   * @return <code>true</code> if this collection changed as a result of the
   *      call
   */
  public boolean add(PropertyChangeResult result) {
    return this.list.add(result);
  }

  /**
   * Returns an iterator over the elements in this collection.
   *
   * @return an iterator over the elements in this collection.
   */
  public PropertyChangeResultIterator iterator() {
    return new PropertyChangeResultIterator(this.list.iterator());
  }
}
