/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;


/**
 * This class is a container for the results of the <code>
 * IResource.setProperties</code> methods. A collection of instances of this class can
 * be contained in a {@link SetPropertiesException}.
 * <p>
 * Copyright (c) SAP AG 2001-2004
 */
public class PropertyChangeResult {

  private IPropertyName propertyName = null;
  private ResourceException exception = null;
  private Integer propChangeIdx = null;

  /**
   * Construct a new PropertyChangeResult.
   *
   * @param propertyName The name of the property that could not be set or
   *      removed
   * @param propChangeIdx The index of the property change that failed. Can be
   *      <code>null</code> .
   * @param ex The exception that occured in the property manager when setting
   *      the property.
   */
  public PropertyChangeResult(IPropertyName propertyName, Integer propChangeIdx, ResourceException ex) {
    this.exception = ex;
    this.propertyName = propertyName;
    this.propChangeIdx = propChangeIdx;
  }

  /**
   * Returns the name of the property that failed
   *
   * @return propertyName
   */
  public IPropertyName getPropertyName() {
    return propertyName;
  }

  /**
   * Returns the index of the entry in the list of property changes. Can be
   * <code>null</code> .
   *
   * @return propertyChangeIndex
   */
  public Integer getPropertyChangeIndex() {
    return propChangeIdx;
  }

  /**
   * Returns the exception that occured in the property manager when setting the
   * property.
   *
   * @return resourceException
   */
  public ResourceException getResourceException() {
    return exception;
  }

  /**
   * Property was set or removed successfull
   *
   * @return oK
   */
  public boolean isOK() {
    return (exception == null);
  }
}

