/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

/**
 * This is a container for positioning information which is used by the
 * reorder() method in <code>IResource</code> <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id:$
 */
public class Positioning implements IPositioning {

  private String m_name = null;
  private IPosition m_pos = null;

  public Positioning(String name, IPosition position) {
    m_name = name;
    m_pos = position;
  }

  public String getResourceName() {
    return m_name;
  }

  public IPosition getPosition() {
    return m_pos;
  }
}
