/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.enum.*;

/**
 * The positioning information required by methods that position resource in
 * ordered collections. <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author m.breitenfelder@sap.com
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/api/com/sapportals/wcm/repository/Position.java#7
 *      $
 */
public class Position implements IPosition {

  private final static Position LAST = new Position(null, OrderPosition.LAST);
  private final static Position FIRST = new Position(null, OrderPosition.FIRST);

  private String relativeName;
  private OrderPosition pos;

  public Position(String relativeName, OrderPosition pos) {
    this.pos = pos;
    this.relativeName = relativeName;
  }


  /**
   * Returns the name of the resource in an ordered collection that will be used
   * to set a relativ position of BEFORE or AFTER.
   *
   * @return relativeName
   */
  public String getRelativeName() {
    return this.relativeName;
  }

  /**
   * The position in the ordered collection.
   *
   * @return position
   */
  public OrderPosition getPosition() {
    return this.pos;
  }

  /**
   * Returns a ready-to-use Position object
   *
   * @return TBD: Description of the outgoing return value
   */
  public static Position createLastPosition() {
    return LAST;
  }

  /**
   * Returns a ready-to-use Position object
   *
   * @return TBD: Description of the outgoing return value
   */
  public static Position createFirstPosition() {
    return FIRST;
  }

  public String toString() {
    if (this.pos.equals(OrderPosition.AFTER)) {
      return "after " + this.relativeName;
    }
    else if (this.pos.equals(OrderPosition.BEFORE)) {
      return "before " + this.relativeName;
    }
    else if (this.pos.equals(OrderPosition.FIRST)) {
      return "first";
    }
    else {
      return "last";
    }
  }

}
