/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.URI;

/**
 * The repository manager does not support the operation. <p>
 *
 * Copyright (c) SAP AG 2001-2004
 *
 * @author m.breitenfelder@sap.com
 * @author julian.reschke@greenbytes.de
 * @version $Revision: 1.21 $
 */
public class NotSupportedException extends ResourceException {

  public NotSupportedException() {
    super(false);
  }

  /**
   * @param msg The message text
   */
  public NotSupportedException(String msg) {
    super(msg, false);
  }

  /**
   * @deprecated as of NW04.
   */
  public NotSupportedException(String msg, URI resourceID) {
    super(msg, resourceID, false);
  }

  /**
   * This constructor is used by the framework to use this exception as a
   * wrapper for a new exception class of the repository manager API.
   *
   * @param newEx The new exception.
   */
  public NotSupportedException(com.sap.netweaver.bc.rf.common.exception.OperationNotSupportedException newEx) {
    super(newEx);
  }

  /**
   * @param msg The message text
   */
  public NotSupportedException(String msg, RID resourceID) {
    super(msg, resourceID, false);
  }
}
