/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.util.uri.RID;

import com.sapportals.wcm.util.uri.URI;

/**
 * The resource is not checked out
 */
public class NotCheckedOutException extends ResourceException {

  /**
   * @param msg
   * @param resourceID
   * @deprecated as of NW04.
   */
  public NotCheckedOutException(String msg, URI resourceID) {
    super(msg, resourceID, false);
  }


  /**
   * @param resourceID
   * @deprecated as of NW04.
   */
  public NotCheckedOutException(URI resourceID) {
    super(resourceID, false);
  }


  /**
   * Constructs a new exception
   *
   * @param msg The message
   * @param resourceID The URI of the resource that caused the exception
   *      (optional)
   */
  public NotCheckedOutException(String msg, RID resourceID) {
    super(msg, resourceID, false);
  }


  /**
   * Constructs a new exception
   *
   * @param resourceID The URI of the resource that caused the exception
   *      (optional)
   */
  public NotCheckedOutException(RID resourceID) {
    super(resourceID, false);
  }

  /**
   * This constructor is used by the framework to use this exception as a
   * wrapper for a new exception class of the repository manager API.
   *
   * @param newEx The new exception.
   */
  public NotCheckedOutException(com.sap.netweaver.bc.rf.common.exception.ResourceNotCheckedOutException newEx) {
    super(newEx);
  }
}
