/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * The resource is not a revision resource.
 */
public class NoRevisionException extends ResourceException {

  /**
   * Constructs a new exception.
   *
   * @param rid The ID of the resource this exception belongs to (optional)
   */
  public NoRevisionException(RID rid) {
    super(rid, false);
  }

  /**
   * Constructs a new exception.
   *
   * @param msg The exception message text
   * @param rid The ID of the resource this exception belongs to (optional)
   */
  public NoRevisionException(String msg, RID rid) {
    super(msg, rid, false);
  }
}
