/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.util.uri.RID;

import com.sapportals.wcm.util.uri.URI;

/**
 * The resource has no content
 */
public class NoContentException extends ResourceException {

  /**
   * @param msg TBD: Description of the incoming method parameter
   * @param resourceID TBD: Description of the incoming method parameter
   * @deprecated as of NW04.
   */
  public NoContentException(String msg, URI resourceID) {
    super(msg, resourceID, false);
  }

  /**
   * Constructs a new NoContentException
   *
   * @param msg The message
   * @param resourceID The URI of the resource that caused the exception
   *      (optional)
   */
  public NoContentException(String msg, RID resourceID) {
    super(msg, resourceID, false);
  }

}
