/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.WcmObject;
import java.util.HashMap;
import java.util.Iterator;

/**
 * Holds a mutable map of Property objects. <p>
 *
 *
 *
 * @author m.breitenfelder@sapportals.com
 * @author julian.reschke@greenbytes.de
 * @version $Revision: 1.17 $
 */
public class MutablePropertyMap extends PropertyMap implements IMutablePropertyMap {

  /**
   * Constructs a new, empty property map
   */
  public MutablePropertyMap() {
    super();
  }

  /**
   * Constructs a new property map with the same mappings as the given map
   *
   * @param propMap The map whose mappings are to be places in this map
   */
  public MutablePropertyMap(MutablePropertyMap propMap) {
    super(propMap);
  }

  /**
   * Constructs a new, empty property map with the specified initial capacity
   *
   * @param initialCapacity The initial capacity of the contained map
   */
  public MutablePropertyMap(int initialCapacity) {
    super(initialCapacity);
  }

  protected MutablePropertyMap(HashMap m) {
    this.map = new HashMap(m);
  }

  // ---------------------------------------------------------------------------------
  // IMutablePropertyMap interface, additional methods not inherited from PropertyMap
  // ---------------------------------------------------------------------------------

  public IProperty put(IProperty property) {
    return (IProperty)this.map.put(property.getPropertyName(), property);
  }

  public IProperty remove(IPropertyName propertyName) {
    return (IProperty)this.map.remove(propertyName);
  }

  public IPropertyMap getImmutable() {
    return new PropertyMap(this.map);
  }

  public void addException(IPropertyName propertyName, Exception ex) {
    if (super.exceptionMap == null) {
      super.exceptionMap = new HashMap();
    }
    super.exceptionMap.put(propertyName, ex);
  }

  // ---------------------------------------------------------------------------
  // IPropertyMap
  // ---------------------------------------------------------------------------

  public IMutablePropertyMap getMutable() {
    return this;
  }
}

