/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.*;

/**
 * The resource was locked by another user.
 */
public class LockedException extends ResourceException {

  private String userID = null;

  /**
   * @param msg TBD: Description of the incoming method parameter
   * @param resourceID TBD: Description of the incoming method parameter
   * @param userID TBD: Description of the incoming method parameter
   * @deprecated as of NW04.
   */
  public LockedException(String msg, URI resourceID, String userID) {
    super(msg, resourceID, false);
    this.userID = userID;
  }

  public LockedException(String msg, RID rid, String userID) {
    super(msg, rid, false);
    this.userID = userID;
  }

  public String getUserID() {
    return this.userID;
  }
}
