/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.IWcmConst;
import com.sapportals.wcm.repository.enum.*;
import java.util.Date;

/**
 * A container for the properties of a lock. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/api/com/sapportals/wcm/repository/LockProperties.java#5
 *      $
 */
public class LockProperties implements ILockProperties {

  protected LockType m_type;

  protected LockScope m_scope;

  protected LockDepth m_depth;

  protected int m_timeout;

  protected XMLMarkup m_clientSuppliedOwner;

  public LockProperties(LockType type, LockScope scope, LockDepth depth, int timeout) {
    m_type = type;
    m_scope = scope;
    m_depth = depth;
    m_timeout = timeout;
    m_clientSuppliedOwner = null;
  }

  public LockProperties(LockType type, LockScope scope, LockDepth depth, int timeout,
    XMLMarkup clientSuppliedOwner) {
    m_type = type;
    m_scope = scope;
    m_depth = depth;
    m_timeout = timeout;
    m_clientSuppliedOwner = clientSuppliedOwner;
  }

  public LockType getType() {
    return m_type;
  }

  public LockScope getScope() {
    return m_scope;
  }

  public LockDepth getDepth() {
    return m_depth;
  }

  public int getTimeout() {
    return m_timeout;
  }

  public XMLMarkup getClientSuppliedOwner() {
    return m_clientSuppliedOwner;
  }

  public void setType(LockType type) {
    m_type = type;
  }

  public void setScope(LockScope scope) {
    m_scope = scope;
  }

  public void setDepth(LockDepth depth) {
    m_depth = depth;
  }

  public void setTimeout(int timeout) {
    m_timeout = timeout;
  }

  public void setClientSuppliedOwner(XMLMarkup clientSuppliedOwner) {
    m_clientSuppliedOwner = clientSuppliedOwner;
  }

}

