/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.util.uri.RID;

import com.sapportals.wcm.util.uri.URI;

/**
 * The requested lock does not exist.
 */
public class LockNotFoundException extends ResourceException {

  /**
   * @param msg TBD: Description of the incoming method parameter
   * @param resourceID TBD: Description of the incoming method parameter
   * @deprecated as of NW04.
   */
  public LockNotFoundException(String msg, URI resourceID) {
    super(msg, resourceID, false);
  }

  /**
   * @param resourceID TBD: Description of the incoming method parameter
   * @deprecated as of NW04.
   */
  public LockNotFoundException(URI resourceID) {
    super(resourceID, false);
  }

  /**
   * Constructs a new exception
   *
   * @param msg The message text
   * @param resourceID TBD: Description of the incoming method parameter
   */
  public LockNotFoundException(String msg, RID resourceID) {
    super(msg, resourceID, false);
  }

  /**
   * Constructs a new exception
   *
   * @param resourceID TBD: Description of the incoming method parameter
   */
  public LockNotFoundException(RID resourceID) {
    super(resourceID, false);
  }

}
