/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.util.*;

/**
 * Implementation of a lock info iterator <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Revision:$
 */
public class LockInfoIterator implements ILockInfoIterator {

  private Iterator m_it = null;

  public LockInfoIterator(Iterator it) {
    m_it = it;
  }

  public boolean hasNext() {
    return m_it.hasNext();
  }

  public ILockInfo next() {
    return (ILockInfo)m_it.next();
  }

  public void remove() {
    m_it.remove();
  }
}
