/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.util.*;

/**
 * Implementation of a lock info collection <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Revision:$
 */
public class LockInfoCollection implements ILockInfoCollection {

  private final List m_list;

  public LockInfoCollection() {
    m_list = new ArrayList(10);
  }

  protected LockInfoCollection(List list) {
    m_list = list;
  }

  // ----------------

  public int size() {
    return m_list.size();
  }

  public boolean contains(String lockToken) {
    for (int i = 0; i < m_list.size(); i++) {
      if (((ILockInfo)m_list.get(i)).getLockToken().equals(lockToken)) {
        return true;
      }
    }
    return false;
  }

  public boolean add(ILockInfo lockInfo) {
    synchronized (m_list) {
      boolean removed = m_list.remove(lockInfo.getLockToken());
      m_list.add(lockInfo);
      return removed;
    }
  }

  public ILockInfo get(String lockToken) {
    for (int i = 0; i < m_list.size(); i++) {
      ILockInfo li = ((ILockInfo)m_list.get(i));
      if (li.getLockToken().equals(lockToken)) {
        return li;
      }
    }
    return null;
  }

  public ILockInfo get(ILockInfo lockInfo) {
    return get(lockInfo.getLockToken());
  }

  public boolean remove(String lockToken) {
    for (int i = 0; i < m_list.size(); i++) {
      ILockInfo li = ((ILockInfo)m_list.get(i));
      if (li.getLockToken().equals(lockToken)) {
        m_list.remove(i);
        return true;
      }
    }
    return false;
  }

  public boolean remove(ILockInfo lockInfo) {
    return remove(lockInfo.getLockToken());
  }

  public ILockInfoIterator iterator() {
    return new LockInfoIterator(m_list.iterator());
  }

  public List getInternalList() {
    return m_list;
  }
}
