/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.util.uri.RID;

import com.sapportals.wcm.util.uri.URI;

/**
 * The target RID specified when creating or updating am internal link is also a
 * link and would cause an loop. That means it would not be possible to resolve
 * the target resource because two or more links would be pointing at each
 * other.
 */
public class LinkLoopException extends ResourceException {

  private RID invalidLinkTarget = null;

  /**
   * Constructs a new exception
   *
   * @param invalidLinkTarget The invalid target resource ID
   */
  public LinkLoopException(RID invalidLinkTarget) {
    super(false);
    this.invalidLinkTarget = invalidLinkTarget;
  }

  /**
   * Constructs a new exception
   *
   * @param msg The message text
   * @param invalidLinkTarget The invalid target resource ID
   */
  public LinkLoopException(String msg, RID invalidLinkTarget) {
    super(msg, false);
    this.invalidLinkTarget = invalidLinkTarget;
  }

  /**
   * Constructs a new exception
   *
   * @param msg The message text
   * @param rid RID of affected recource
   * @param invalidLinkTarget The invalid target resource ID
   */
  public LinkLoopException(String msg, RID rid, RID invalidLinkTarget) {
    super(msg, rid, false);
    this.invalidLinkTarget = invalidLinkTarget;
  }

  /**
   * Returns the link target that caused the exception. Can be <code>null</code>
   * .
   *
   * @return linkTargetRID
   */
  public RID getLinkTargetRID() {
    return this.invalidLinkTarget;
  }
}
