/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * The application tried add a label that already exists in the version history.
 * <p>
 *
 * Copyright (c) SAP AG 2002
 *
 * @author martin.boettcher@greenbytes.de
 * @version $Id: LabelAlreadyExistsException.java,v 1.2 2002/08/30 11:35:43 jre
 *      Exp $
 */
public class LabelAlreadyExistsException extends ResourceException {

  private final String label;

  /**
   * Constructs a new exception
   *
   * @param msg The message
   * @param resourceID The RID of the resource that caused the exception
   *      (optional)
   * @param label TBD: Description of the incoming method parameter
   */
  public LabelAlreadyExistsException(String msg, String label, RID resourceID) {
    super(msg, resourceID, false);
    this.label = label;
  }

  /**
   * Constructs a new exception
   *
   * @param resourceID The RID of the resource that caused the exception
   *      (optional)
   * @param label TBD: Description of the incoming method parameter
   */
  public LabelAlreadyExistsException(String label, RID resourceID) {
    super(resourceID, false);
    this.label = label;
  }

  /**
   * @return the affected label
   */
  public String getLabel() {
    return this.label;
  }
}
