/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * An invalid URI was used. The framework throws this exception in these cases
 * (e.g. in the IResourceFactory.getResource() method): <br>
 * - null <br>
 * - empty string <br>
 * - does not start with a slash <br>
 * - contains a back-slash <br>
 * - contains the sub-string "//" <br>
 * - unknown repository name (The first part of the RID path)
 */
public class InvalidUriException extends ResourceException {

  /**
   * Constructs a new exception
   *
   * @param msg The message text
   */
  public InvalidUriException(String msg) {
    super(msg, false);
  }

  /**
   * Constructs a new exception
   *
   * @param msg The message text
   * @param invalidRID TBD: Description of the incoming method parameter
   */
  public InvalidUriException(String msg, RID invalidRID) {
    super(msg, invalidRID, false);
  }
}
