/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.util.uri.RID;

import com.sapportals.wcm.util.uri.URI;

/**
 * An invalid target was used for a copy or move operation.
 */
public class InvalidTargetException extends ResourceException {

  private RID invalidTarget = null;

  /**
   * @param invalidTarget TBD: Description of the incoming method parameter
   * @deprecated as of NW04.
   */
  public InvalidTargetException(URI invalidTarget) {
    super(false);
    this.invalidTarget = RID.getRID(invalidTarget.toString());
  }

  /**
   * @param msg TBD: Description of the incoming method parameter
   * @param invalidTarget TBD: Description of the incoming method parameter
   * @deprecated as of NW04.
   */
  public InvalidTargetException(String msg, URI invalidTarget) {
    super(msg, false);
    this.invalidTarget = RID.getRID(invalidTarget.toString());
  }

  /**
   * Constructs a new exception
   *
   * @param invalidTarget TBD: Description of the incoming method parameter
   */
  public InvalidTargetException(RID invalidTarget) {
    super(invalidTarget, false);
    this.invalidTarget = invalidTarget;
  }

  /**
   * Constructs a new exception
   *
   * @param msg The message text
   * @param invalidTarget TBD: Description of the incoming method parameter
   */
  public InvalidTargetException(String msg, RID invalidTarget) {
    super(msg, invalidTarget, false);
    this.invalidTarget = invalidTarget;
  }

  /**
   * @return invalidTarget
   * @deprecated as of NW04.
   */
  public URI getInvalidTarget() {
    return new URI(this.invalidTarget.toString());
  }

  /**
   * Returns the invalid target that caused the exception. Can be <code>null
   * </code>.
   *
   * @return invalidTargetRID
   */
  public RID getInvalidTargetRID() {
    return this.invalidTarget;
  }
}
