/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * The required positioning was not valid (usually because the referenced
 * collection member did not exist). <p>
 *
 * Copyright (c) SAP AG 2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: InvalidPositionException.java,v 1.1 2003/01/08 13:06:14 jre Exp
 *      $
 */
public class InvalidPositionException extends ResourceException {

  /**
   * @param resourceID resource id of the collection member that couldn't be
   *      positioned.
   * @param message TBD: Description of the incoming method parameter
   */
  public InvalidPositionException(String message, RID resourceID) {
    super(message, resourceID, false);
  }
}
