/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

/**
 * The application tried to use a invalid resource name
 */
public class InvalidNameException extends ResourceException {

  NameInfo ni = null;


  /**
   * Construct a new exception.
   *
   * @param msg The message text
   * @param ni The name info object of the repository
   */
  public InvalidNameException(String msg, NameInfo ni) {
    super(msg, false);
    this.ni = ni;
  }


  /**
   * This constructor is used by the framework to use this exception as a
   * wrapper for a new exception class of the repository manager API.
   *
   * @param newEx The new exception.
   * @param ni The name info object of the repository.
   */
  public InvalidNameException(
    com.sap.netweaver.bc.rf.common.namespace.ResourceNameInvalidException newEx,
    NameInfo ni) {
    super(newEx);
    this.ni = ni;
  }


  /**
   * Returns a name info object of the repository
   *
   * @return a name info object of the repository
   */
  public NameInfo getNameInfo() {
    return this.ni;
  }

}
