/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * One ore more invalid values where provided for the parameters of a method.
 */
public class InvalidArgumentException extends ResourceException {

  /**
   * Constructs a new exception
   *
   * @param msg The message text
   */
  public InvalidArgumentException(String msg) {
    super(msg, false);
  }

  public InvalidArgumentException(String msg, RID rid) {
    super(msg, rid, false);
  }
  
  public InvalidArgumentException(String msg, RID rid, Exception e) {
	  super(msg, rid, e, false);
	}

}
