/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

/**
 * The requested RID contains an internal link to a collection. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author Markus Breitenfelder
 * @version $Id:$
 */
public class InternalLinkException extends ResourceException {

  private String knownRIDPart;

  private String unknownRIDPart;

  /**
   * Constructs a new exception
   *
   * @param msg The message text
   * @param knownRIDPart part of thr requested URI that is known to the
   *      repository (format: URI-encoded)
   * @param unknownRIDPart "remainder" of the URI (format: not encoded)
   */
  public InternalLinkException(String msg, String knownRIDPart, String unknownRIDPart) {
    super(msg, false);
    this.knownRIDPart = knownRIDPart;
    this.unknownRIDPart = unknownRIDPart;
  }

  /**
   * Constructs a new exception
   *
   * @param knownRIDPart part of thr requested URI that is known to the
   *      repository (format: URI-encoded)
   * @param unknownRIDPart TBD: Description of the incoming method parameter
   */
  public InternalLinkException(String knownRIDPart, String unknownRIDPart) {
    super(false);
    this.knownRIDPart = knownRIDPart;
    this.unknownRIDPart = unknownRIDPart;
  }


  /**
   * Returns the part of the requested RID that was known to the repository
   * (format: URI-encoded), may be <code>null</code>
   *
   * @return part of the requested RID that was known to the repository (format:
   *      URI-encoded), may be <code>null</code>
   */
  public String getKnownRIDPart() {
    return this.knownRIDPart;
  }

  /**
   * Returns the "remainder" of the RID (format: not encoded)
   *
   * @return "remainder" of the RID (format: not encoded)
   */
  public String getUnknownRIDPart() {
    return this.unknownRIDPart;
  }
}
