/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.util.uri.IRidList;
import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.RidList;

import com.sapportals.wcm.util.uri.URI;

import java.util.Collection;

/**
 * An operation did not complete because of precondition failures. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: IncompleteOperationException.java,v 1.8 2002/11/22 12:53:30 jre
 *      Exp $
 */
public class IncompleteOperationException extends ResourceException {

  private IRidList successfulOperations = new RidList();


  /**
   * @param firstException
   * @param resourceID
   * @deprecated as of NW04. <code>URI</code> migrated to <code>RID</code> .
   */
  public IncompleteOperationException(ResourceException firstException, URI resourceID) {
    super(resourceID, false);
    super.setNextResourceException(firstException);
  }


  /**
   * @param msg
   * @param firstException
   * @param resourceID
   * @deprecated as of NW04. <code>URI</code> migrated to <code>RID</code> .
   */
  public IncompleteOperationException(String msg, ResourceException firstException, URI resourceID) {
    super(msg, resourceID, false);
    super.setNextResourceException(firstException);
  }


  /**
   * Constructs a new exception
   *
   * @param firstException The first resource exception in the chain.
   * @param resourceID The ID of the resource this exception belongs to
   *      (optional)
   */
  public IncompleteOperationException(ResourceException firstException, RID resourceID) {
    super(resourceID, false);
    super.setNextResourceException(firstException);
  }


  /**
   * Constructs a new exception
   *
   * @param msg The exception message text
   * @param firstException The first resource exception in the chain.
   * @param resourceID The ID of the resource this exception belongs to
   *      (optional)
   */
  public IncompleteOperationException(String msg, ResourceException firstException, RID resourceID) {
    super(msg, resourceID, false);
    super.setNextResourceException(firstException);
  }


  /**
   * This constructor is used by the framework to use this exception as a
   * wrapper for a new exception class of the repository manager API.
   *
   * @param newEx The new exception.
   */
  public IncompleteOperationException(com.sap.netweaver.bc.rf.common.exception.OperationNotCompletedException newEx) {
    super(newEx);
  }


  public void setSuccessfulOperations(IRidList ridList) {
    this.successfulOperations = ridList;
  }


  public IRidList getSuccessfulOperations() {
    return this.successfulOperations;
  }


  public void addSuccessfulOperation(RID rid) {
    this.successfulOperations.add(rid);
  }
}
