/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.util.name.IName;

import com.sapportals.wcm.util.uri.RID;

/**
 * Raised when a property name was not acceptable. <p>
 *
 * Copyright (c) SAP AG 2002
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: IllegalPropertyNameException.java,v 1.1 2002/11/07 16:26:11 jre
 *      Exp $
 */
public class IllegalPropertyNameException extends AbstractPropertyException implements IName {

  private String namespace, name;

  public IllegalPropertyNameException(String message, RID rid, String namespace, String name) {
    super(message, rid, null);
    this.namespace = namespace;
    this.name = name;
  }

  public String getName() {
    return this.name;
  }

  public String getNamespaceOrNull() {
    return this.namespace;
  }

  public String getNamespace() {
    return this.namespace == null ? "" : this.namespace;
  }

}
