/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * Extended interface for resources under workspace control. <p>
 *
 * Copyright (c) SAP AG 2002-2004
 *
 * @author manfred.baedke@greenbytes.de
 */
public interface IWorkspaceControlledResource {

  /**
   * @return the rid of the workspace controlling the resource
   * @exception ResourceException Exception raised in failure situation
   */
  public RID getWorkspaceRID()
    throws ResourceException;
}
