/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * Interface for working resources (see <a
 * href="http://greenbytes.de/tech/webdav/rfc3253.html#rfc.section.9">RFC3253<a>
 * ). <p>
 *
 * Copyright (c) SAP AG 2002-2004
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: IWorkingResource.java,v 1.3 2004/03/23 13:20:46 jre Exp $
 */
public interface IWorkingResource {

  /**
   * @return the RID of the version controlled resource from which the working
   *      resource was created. Otherwise <code>null</code> .
   * @exception ResourceException Exception raised in failure situation
   */
  public RID getAutoUpdateVCR()
    throws ResourceException;

}

