/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.*;

/**
 * Interface for version history resources. <p>
 *
 * Copyright (c) SAP AG 2002-2004
 * @author julian.reschke@greenbytes.de
 * @version $Id: IVersionHistoryResource.java,v 1.5 2002/05/24 11:30:11 jre Exp
 * @see <a href="http://greenbytes.de/tech/webdav/rfc3253.html#version-history.feature">RFC3253, section 5</a>
 */
public interface IVersionHistoryResource {

  /**
   * @return root version resource in version history
   * @exception ResourceException Exception raised in failure situation
   */
  public IResource getRootVersionResource()
    throws ResourceException;

  /**
   * @return RID of root version in version history
   * @exception ResourceException Exception raised in failure situation
   */
  public RID getRootVersionRID()
    throws ResourceException;

  /**
   * @return RIDs of VCRs for this VHR (or empty list when none exists or can't
   *      be located in scope of the repository manager)
   * @exception ResourceException Exception raised in failure situation
   */
  public IRidSet getVersionControlledResourceRIDs()
    throws ResourceException;

  /**
   * @param scope scope in which to search for VCR
   * @return RIDs of VCRs (one per resource) for this VHR (or empty list when
   *      none exists or can't be located in scope of the repository manager)
   * @exception ResourceException Exception raised in failure situation
   */
  public IRidSet getVersionControlledResourceRIDs(RID scope)
    throws ResourceException;

  /**
   * @param label label to search for
   * @return RID of version identified by the given label (or <code>null</code>
   *      if there's no version with that label)
   * @exception ResourceException Exception raised in failure situation
   */
  public RID getVersionRIDByLabel(String label)
    throws ResourceException;

  /**
   * @param label label to search for
   * @return version resource identified by the given label (or <code>null
   *      </code> if there's no version with that label)
   * @exception ResourceException Exception raised in failure situation
   */
  public IResource getVersionResourceByLabel(String label)
    throws ResourceException;

  /**
   * @return set of versions in this version history.
   * @throws ResourceException
   */
  public IResourceList getVersionResourceSet()
    throws ResourceException;

  /**
   * @return set of versions in this version history.
   * @throws ResourceException
   */
  public IRidSet getVersionRidSet()
    throws ResourceException;

}

