/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

/**
 * Interface for collections that support automatic versioning of all member
 * resources. <p>
 *
 * Copyright (c) SAP AG 2002-2004
 * @author martin.boettcher@greenbytes.de
 * @author julian.reschke@greenbytes.de
 * @version $Id: IVersionController.java,v 1.3 2004/03/23 13:20:46 jre Exp $
 */
public interface IVersionController {

  /**
   * Enables child version controlling for this collection -- if a new
   * non-collection child is created it will be put under version control
   * immediately and automatically. As a side effect, enables version control
   * for all existing children that are versionable.
   *
   * @param modifiedResources when present (not <code>null</code>, this list will
   * be filled with the modified resources)
   * @exception ResourceException Exception raised in failure situation
   */
  public void enable(IResourceList modifiedResources)
    throws ResourceException;

  /**
   * Disables child version controlling for this collection.
   *
   * @param disableChildVersioning if <code>true</code> , version control will
   *      be disabled for all direct children of this resource. Whether the
   *      version histories and all revisions will be deleted is determined by
   *      the default of the repository manager.
   * @exception ResourceException Exception raised in failure situation
   */
  public void disable(boolean disableChildVersioning)
    throws ResourceException;

  /**
   * @return whether automatic child version controlling is enabled
   * @exception ResourceException Exception raised in failure situation
   */
  public boolean isEnabled()
    throws ResourceException;
}
