/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.WcmException;
import java.util.Comparator;
import java.util.Map;

/**
 * A typed list of <code>IResource</code> instances. This interface extends the
 * <code>IResourceList</code> : It can be used for lists of resources other than
 * the children of colletions and can carry arbitrary type information in it's
 * type attribute. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Revision:$
 */
public interface ITypedResourceList extends IResourceList {

  /**
   * Returns the resource list's type attribute
   *
   * @return The resource list's type attribute. Can be <code>null</code> .
   */
  public String getType();

  /**
   * Set the type attributes
   *
   * @param type type to be set
   */
  public void setType(String type);

  /**
   * @param resource a resource contained in the list.
   * @return Returns a property bag for a resource contained in the list.
   *      Returns <code>null</code> if the specified resource is not contained
   *      in the list or no property bag is associated with the resource.
   */
  public Map getPropertyBag(IResource resource);

  /**
   * Set a property bag for a resource contained in the list.
   *
   * @param resource A resource contained in the list.
   * @param propertyBag Properties to store.
   * @exception WcmException If the specified resource is not contained in the
   *      list.
   */
  public void setPropertyBag(IResource resource, Map propertyBag)
    throws WcmException;
}

