/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

/**
 * This interface provides access to a set of supported options for a resource.
 * <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Revision: 1.18 $
 */
import com.sapportals.wcm.repository.enum.SupportedOption;

import java.util.Iterator;

/**
 * TBD: Description of the interface.
 */
public interface ISupportedOptionSet {

  /**
   * Checks whether the option is supported.
   *
   * @param op option
   * @return supported
   * @returns <code>true</code> when supported.
   */
  public boolean isSupported(SupportedOption op);

  /**
   * Add an option to the set.
   *
   * @param op option
   */
  public void add(SupportedOption op);

  public Iterator iterator();

}
