/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.IRidSet;

/**
 * Extended interface for resources that provide additional meta-information.
 * <p>
 *
 * Copyright (c) SAP AG 2002-2004
 * @author manfred.baedke@greenbytes.de
 */
public interface IResourceMetadata {

  /**
   * Returns a set of collections that are able to contain/create workspace
   * resources.
   *
   * @return a set of collections
   * @exception ResourceException Exception raised in failure situation
   */
  public IRidSet getWorkspaceCollectionSet()
    throws ResourceException;

  /**
   * Returns a set of collections that are used to store version history
   * resources.
   *
   * @return a set of collections containing version histories
   * @exception ResourceException Exception raised in failure situation
   */
  public IRidSet getVersionHistoryCollectionSet()
    throws ResourceException;
}
