/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

/**
 * An iterator for the resource list
 *
 * @author SAP AG
 * @version $Revision:$
 */
public interface IResourceListIterator {

  public boolean hasNext();

  public IResource next();

  public boolean hasPrevious();

  public IResource previous();

  public int nextIndex();

  public int previousIndex();

  public void remove();

  public void set(IResource resource);

  public void add(IResource resource);

}

