/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.portal.security.usermanagement.IUser;

import java.util.*;

/**
 * The context that contains information for all repository operations belonging
 * to one request, session, etc.
 *
 * @author SAP AG
 * @version $Revision: #5 $
 */
public interface IResourceContext {

  public final static String NO_KEYWORD_SUBSTITUTION = "no-keyword-substitution";

  /**
   * Add/update a name/value pair
   *
   * @param name A unique name
   * @param value The value
   * @exception ResourceException If the name paramater is invalid
   */
  public void setValue(String name, String value)
    throws ResourceException;

  /**
   * Returns the value for the specified name
   *
   * @param name TBD: Description of the incoming method parameter
   * @return The value or null if the name was not found
   */
  public String getValue(String name);

  /**
   * Add/update a name/value pair
   *
   * @param name A unique name
   * @param value An object
   * @exception ResourceException If the name paramater is invalid
   */
  public void setObjectValue(String name, Object value)
    throws ResourceException;

  /**
   * Returns the value for the specified name
   *
   * @param name TBD: Description of the incoming method parameter
   * @return The result object or null if the name was not found
   */
  public Object getObjectValue(String name);

  /**
   * Takes and sets the properties as is without copying them to be used and
   * possibly modified as internal properties map.
   *
   * @param properties properties
   */
  public void setValues(HashMap properties);

  /**
   * Returns the internal properties map as is without copying them to be used
   * and possible modified from outside.
   *
   * @return properties
   */
  public HashMap getValues();

  /**
   * Set the locale for that context.
   *
   * @param locale locale to be set
   * @see java.util.Locale
   */
  public void setLocale(Locale locale);

  /**
   * Get the locale for that context.
   *
   * @return <code>Locale</code> the locale to use.
   * @see java.util.Locale
   */
  public Locale getLocale();

  /**
   * Set the current user for that context.
   *
   * @param user user to be set
   */
  public void setUser(IUser user);

  /**
   * Get the current user for that context.
   *
   * @return <code>IUser</code> the user.
   */
  public IUser getUser();
}
