/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

/**
 * This interface defines a list of <code>IPositioning</code> objects. It is
 * used by the reorder() methods in <code>IResource</code> . <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id:$
 */
public interface IReorderList {

  /**
   * Returns the number of positioning objects in the list
   *
   * @return TBD: Description of the outgoing return value
   */
  public int size();

  /**
   * Appends the specified positioning object to the end of the list
   *
   * @param positioning TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public boolean add(IPositioning positioning);

  /**
   * Returns the positioning object with the specified index
   *
   * @param index TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public IPositioning get(int index);

  /**
   * Inserts the specified positioning object at the specified position in the
   * list
   *
   * @param index TBD: Description of the incoming method parameter
   * @param positioning TBD: Description of the incoming method parameter
   */
  public void add(int index, IPositioning positioning);

  /**
   * Returns a list iterator
   *
   * @return TBD: Description of the outgoing return value
   */
  public IReorderListIterator listIterator();
}
