/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

/**
 * An Iterator for a property map
 *
 * @see IPropertyMap
 */
public interface IPropertyIterator {

  /**
   * True if next() can be called
   *
   * @return Boolean value
   */
  public boolean hasNext();

  /**
   * Returns the next property in the map
   *
   * @return The property
   */
  public IProperty next();

  /**
   * Removes a property from the property map
   */
  public void remove();

}

