/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.WcmException;

import com.sapportals.wcm.repository.enum.*;
import java.util.Properties;

/**
 * Information about the type, name and other attributes of a property.
 *
 * @author SAP AG
 * @version $Revision: #25 $
 */
public interface IPropertyDef {

  /**
   * Returns true if the property is multi-valued.
   *
   * @return A boolean value
   */
  boolean isMultivalued();

  /**
   * Returns the value of the Required attribute
   *
   * @return A boolean value
   */
  boolean isRequired();

  /**
   * Returns the type of the property.
   *
   * @return type
   */
  PropertyType getType();

  /**
   * Returns the value of the Readonly attribute
   *
   * @return readonly
   */
  boolean isReadonly();

  /**
   * Returns the value of the Indexed attribute
   *
   * @return indexed
   */
  boolean isIndexed();

  /**
   * Returns the value of the Hidden attribute
   *
   * @return hidden
   */
  boolean isHidden();

  /**
   * Get the value of an attribute.
   *
   * @param name Attribute name
   * @return The value
   */
  String getAttribute(String name);


  /**
   * Returns a collection of attributes
   *
   * @return All attributes
   */
  Properties getAttributes();

  /**
   * Returns the description of the property definition
   */
  //public String getDescription() throws WcmException;

  /**
   * Returns the description of the property definition, using the locale from
   * the resource context
   */
  //public String getDescription(IResourceContext context) throws WcmException;
}
