/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.enum.*;

/**
 * The positioning information required by methods that position resource in
 * ordered collections.
 */
public interface IPosition {
  /**
   * Returns the name of the resource in an ordered collection that will be used
   * to set a relativ position of BEFORE or AFTER.
   *
   * @return relativeName
   */
  String getRelativeName();

  /**
   * The position in the ordered collection.
   *
   * @return position
   */
  OrderPosition getPosition();

}
