/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.IUri;

/**
 * Interfaces for collections that support ordering. <p>
 *
 * Copyright (c) SAP AG 2003-2004
 * @author julian.reschke@greenbytes.de
 * @version $Id: IOrderableCollection.java,v 1.3 2004/03/23 13:20:46 jre Exp $
 * @see <a href="http:/greenbytes.de/tech/webdav/rfc3648.html">RFC3648</a>
 */
public interface IOrderableCollection {

  /**
   * Returns information about the collection's ordering, where the following
   * URIs are reserved: <p>
   *
   * "DAV:unordered": unordered collection<br>
   * "DAV:custom": client-maintained ordering, no additional information about
   * the ordering semantics available <p>
   *
   * Any other URI identifies an ordering for which additional information
   * semantics MAY be available at the given URI
   *
   * @return the ordering type
   * @exception ResourceException Exception raised in failure situation
   */
  public IUri getOrderingType()
    throws ResourceException;

  /**
   * Sets the collection's ordering type. For a definition of predefined URIs,
   * see {@link #getOrderingType()}.
   *
   * @param orderingType orderingType to be set
   * @exception ResourceException Exception raised in failure situation
   */
  public void setOrderingType(IUri orderingType)
    throws ResourceException;
}
