/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.util.uri.RID;

import com.sapportals.wcm.util.uri.URI;

/**
 * An IO error occured while trying to access a resource.
 */
public class IOErrorException extends ResourceException {

  /**
   * @param msg
   * @param resourceID
   * @deprecated as of NW04. <code>URI</code> migrated to <code>RID</code> .
   */
  public IOErrorException(String msg, URI resourceID) {
    super(msg, resourceID, false);
  }


  /**
   * @param msg
   * @param ex
   * @param resourceID
   * @deprecated as of NW04. <code>URI</code> migrated to <code>RID</code> .
   */
  public IOErrorException(String msg, Exception ex, URI resourceID) {
    super(msg, resourceID, ex, false);
  }


  /**
   * Constructs a new IOErrorException
   *
   * @param msg The message
   * @param resourceID The URI of the resource that caused the exception
   *      (optional)
   */
  public IOErrorException(String msg, RID resourceID) {
    super(msg, resourceID, false);
  }


  /**
   * Constructs a new IOErrorException
   *
   * @param msg The message
   * @param ex The contained exception
   * @param resourceID The URI of the resource that caused the exception
   *      (optional)
   */
  public IOErrorException(String msg, Exception ex, RID resourceID) {
    super(msg, resourceID, ex, false);
  }


  /**
   * This constructor is used by the framework to use this exception as a
   * wrapper for a new exception class of the repository manager API.
   *
   * @param newEx The new exception.
   */
  public IOErrorException(com.sap.netweaver.bc.rf.common.exception.IOOperationFailedException newEx) {
    super(newEx);
  }
}
