/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.util.Iterator;

/**
 * An extention of the <code>IPropertyMap</code> interface with methods to
 * modify the map. <p>
 *
 *
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Revision: 1.17 $
 */
public interface IMutablePropertyMap extends IPropertyMap {

  /**
   * Puts a property into the map. Associates the property with the it's {@link
   * IPropertyName} as a key in this map. If the map previously contained a
   * mapping for this name, the old property is replaced.
   *
   * @param property The property to add.
   * @return previous value associated with specified property's name, or null
   *      if there was no mapping.
   */
  public IProperty put(IProperty property);

  /**
   * Removes the mapping for the specified property name from this map if
   * present.
   *
   * @param propertyName TBD: Description of the incoming method parameter
   * @return previous value associated with specified name, or null if there was
   *      no mapping.
   */
  public IProperty remove(IPropertyName propertyName);

  /**
   * Returns a read-only version of this map. The map is not copied.
   *
   * @return a read-only version of this map
   */
  public IPropertyMap getImmutable();

  /**
   * Record an exception for a particular property.
   *
   * @param propertyName name of property
   * @param ex exception
   */
  public void addException(IPropertyName propertyName, Exception ex);

}

