/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.util.Date;

/**
 * Interfaces for updates on those parts of content metadata that change when
 * the content is actually persisted by the repository manager. <p>
 *
 * Copyright (c) SAP AG 2002-2004
 *
 * @author julian.reschke@greenbytes.de
 * @version $Revision: 1.3 $
 */
public interface IMutableEntityMetadata extends IEntityMetadata {

  /**
   * @param entityTag entity-tag (see <a href="http:/greenbytes.de/tech/webdav/rfc2616.html#header.etag">RFC2616</a> , section 14.19).
   * @exception ResourceException Exception raised in failure situation
   */
  public void setEntityTag(String entityTag)
    throws ResourceException;

  /**
   * @param lastModified last modified timestamp (see <a href="http:/greenbytes.de/tech/webdav/rfc2616.html#header.last-modified">RFC2616</a> , section 14.29)
   * @exception ResourceException Exception raised in failure situation
   */
  public void setLastModified(Date lastModified)
    throws ResourceException;

  /**
   * @return whether the meta data was actually updated during the storage
   *      operation (create resource / update content).
   */
  public boolean wasUpdated();
}
