/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.enum.*;

/**
 * A container for the properties of a lock. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/api/com/sapportals/wcm/repository/ILockProperties.java#5
 *      $
 */
public interface ILockProperties {

  public LockType getType();

  public LockScope getScope();

  public LockDepth getDepth();

  public int getTimeout();

  public XMLMarkup getClientSuppliedOwner();

  public void setType(LockType type);

  public void setScope(LockScope scope);

  public void setDepth(LockDepth depth);

  public void setTimeout(int timeout);

  public void setClientSuppliedOwner(XMLMarkup clientSuppliedOwner);

}

