/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

/**
 * This interface defines a collection of ILockInfo instances <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @author julian.reschke@greenbytes.de
 * @version $Revision: 1.10 $
 */
public interface ILockInfoCollection {

  /**
   * @return The collection size
   */
  public int size();


  /**
   * Description of the Method
   *
   * @param lockToken Description of the Parameter
   * @return Description of the Return Value
   */
  public boolean contains(String lockToken);


  /**
   * Description of the Method
   *
   * @param lockInfo Description of the Parameter
   * @return Description of the Return Value
   */
  public boolean add(ILockInfo lockInfo);


  /**
   * Description of the Method
   *
   * @param lockToken Description of the Parameter
   * @return Description of the Return Value
   */
  public ILockInfo get(String lockToken);


  /**
   * Description of the Method
   *
   * @param lockInfo Description of the Parameter
   * @return Description of the Return Value
   */
  public ILockInfo get(ILockInfo lockInfo);


  /**
   * Description of the Method
   *
   * @param lockToken Description of the Parameter
   * @return Description of the Return Value
   */
  public boolean remove(String lockToken);


  /**
   * Description of the Method
   *
   * @param lockInfo Description of the Parameter
   * @return Description of the Return Value
   */
  public boolean remove(ILockInfo lockInfo);


  /**
   * Description of the Method
   *
   * @return Description of the Return Value
   */
  public ILockInfoIterator iterator();


  // workaround because LockManager.getLocks must return the list (jre)
  /**
   * Gets the internalList attribute of the ILockInfoCollection object
   *
   * @return The internalList value
   */
  public java.util.List getInternalList();
}

