/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.enum.*;

import java.util.Date;

/**
 * Information about a specific lock. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @author julian.reschke@greenbytes.de
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/api/com/sapportals/wcm/repository/ILockInfo.java#7
 *      $
 */

public interface ILockInfo {

  /**
   * @return {@link LockType} of lock.
   */
  public LockType getType();

  /**
   * @return {@link LockScope} of lock.
   */
  public LockScope getScope();

  /**
   * @return creation timestamp
   */
  public Date getCreated();

  /**
   * @return {@link LockDepth} of lock.
   */
  public LockDepth getDepth();

  /**
   * @return get timeout of seconds.
   */
  public int getTimeout();

  /**
   * @return user id of lock owner.
   */
  public String getOwner();

  /**
   * @return expiration time of lock.
   */
  public Date getExpiration();

  /**
   * @return time remaining until expiry in seconds (or <code>-1</code> for
   *      "infinite").
   */
  public long timeRemaining();

  /**
   * The lock token must be either an absolute URI (as defined in <a
   * href="http://www.ietf.org/rfc/rfc2396.txt">RFC2396</a> or a relative URI
   * reference (in which case the <a href="http://greenbytes.de/tech/webdav/rfc2518.html#rfc.section.6.4">
   * opaquelocktoken</a> URI scheme is assumed).
   *
   * @return lock token.
   */
  public String getLockToken();

  /**
   * A client can submit his own owner information that SHOULD be returned upon
   * lock discovery. If present, the format MUST be the XML serialization of a
   * <a href="http://www.greenbytes.de/tech/webdav/rfc2518.html#ELEMENT_owner" >
   * DAV:owner</a> element.
   *
   * @return lock owner information as submitted by client (may be <code>null
   *      </code> if not available).
   */
  public XMLMarkup getClientSuppliedOwner();

}

