/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.*;
import com.sapportals.wcm.repository.enum.*;
import com.sapportals.wcm.util.content.*;

/**
 * A WCM link is used to create links to repository resources and URL resources
 * on external servers. <p>
 *
 * Copyright (c) SAP AG 2002
 *
 * @author m.breitenfelder@sap.com
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/api/com/sapportals/wcm/repository/ILink.java#7
 *      $
 */
public interface ILink {

  /**
   * Returns the target URL
   *
   * @return The URL value
   * @exception ResourceException
   */
  public String getURL()
    throws ResourceException;


  /**
   * Returns the link type
   *
   * @return The linkType value
   * @exception ResourceException
   */
  public LinkType getLinkType()
    throws ResourceException;
}
