/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.*;

/**
 * Extended interface for internal link resources. <p>
 *
 * Two types of links are supported: <p>
 *
 * 1) <em>static</em> links behave like symbolic links in POSIX: there is no
 * live connection to the link target, links may be relative and may point to
 * non-existing targets. <p>
 *
 * 2) <em>dynamic</em> links can only be created for an existing target
 * resource, and "follow" this target resource automatically upon MOVE/RENAME,
 * and disappear when the target is deleted or moved to a different target
 * repository. Note that in general, dynamic links do <em>not</em> work across
 * repository boundaries. <p>
 *
 * Copyright (c) SAP AG 2002-2004
 * @author julian.reschke@greenbytes.de
 * @version $Id: IInternalLinkResource.java,v 1.3 2004/03/23 13:20:46 jre Exp $
 */
public interface IInternalLinkResource {

  /**
   * Gets the link target. <p>
   *
   * <em>Note:</em> this information may be non-live.
   *
   * @return the link target resource (or <code>null</code> when it does not
   *      exist)
   * @exception ResourceException Exception raised in failure situation
   */
  public IResource getTargetResource()
    throws ResourceException;

  /**
   * Gets the link target. <p>
   *
   * <em>Note:</em> this information may be non-live.
   *
   * @return the RID of the link target (or <code>null</code> when it does not
   *      exist)
   * @exception ResourceException Exception raised in failure situation
   */
  public RID getTargetRID()
    throws ResourceException;

  /**
   * Sets the link target.
   *
   * @param target targetRID to be set
   * @exception ResourceException Exception raised in failure situation
   */
  public void setTargetRID(RID target)
    throws ResourceException;

  /**
   * @return whether the link is dynamic or static
   * @exception ResourceException Exception raised in failure situation
   */
  public boolean isDynamic()
    throws ResourceException;

  /**
   * @return whether the redirection is permanent (equivalent to HTTP status
   *      301) or not (302)
   * @exception ResourceException Exception raised in failure situation
   */
  public boolean isPermanent()
    throws ResourceException;
}
