/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.*;

/**
 * Interface for external link resources. <p>
 *
 * Copyright (c) SAP AG 2002-2004
 * @author julian.reschke@greenbytes.de
 * @version $Id: IExternalLinkResource.java,v 1.3 2004/03/23 13:20:46 jre Exp $
 */
public interface IExternalLinkResource {

  /**
   * @return the {@link IUri} of the link target.
   * @exception ResourceException Exception raised in failure situation
   */
  public IUri getTargetUri()
    throws ResourceException;

  /**
   * @return whether the redirection is permanent (equivalent to HTTP status
   *      301) or not (302).
   * @exception ResourceException Exception raised in failure situation
   */
  public boolean isPermanent()
    throws ResourceException;

  /**
   * Sets the link target.
   *
   * @param target targetUri to be set
   * @exception ResourceException Exception raised in failure situation
   */
  public void setTargetUri(IUri target)
    throws ResourceException;
}
